--> NOTA : le collecteur de donnes n'est apparu qu' partir de la version 2008 de SQL Server

-- Rcupration de lidentifiant de frquence de collecte
-- pour une collecte toutes les 30 minutes depuis la table
-- des planifications de lAgent SQL
DECLARE @schedule uniqueidentifier;
SELECT @schedule = schedule_uid
FROM   msdb.dbo.sysschedules
WHERE  name = N'CollectorSchedule_Every_30min';

-- Affiche pour information lUID rcupr
SELECT @schedule AS UID_schedule;

-- Cration du jeu de collectes
DECLARE @collectionsetid int,
        @collectionsetuid uniqueidentifier;
EXEC msdb.dbo.sp_syscollector_create_collection_set
              @name = N'Rapport de fragmentation des index',
              @collection_mode = 1, -- sans utilisation du cache
              @description = N'Enregistre les donnes de fragmentation pour les index composs de plus de 100 pages',
              @days_until_expiration = 400, -- Conserve les donnes 400 jours
              @schedule_uid = @schedule,
              @collection_set_id = @collectionsetid OUTPUT,
			  @collection_set_uid = @collectionsetuid OUTPUT;

-- Dfinit ce qui va tre monitor sous forme XML,
-- ce XML conforme au XSD "DataCollectorType" / "TSQLQueryCollector"
-- NOTA : les collections de schma XML pour la gestion des collecteurs
-- ont t cres dans la base MSDB
DECLARE @parameters XML;
SET @parameters = CAST(
N'
<ns:TSQLQueryCollector xmlns:ns="DataCollectorType">
   <Query>
      <Value>
WITH
T_FRAG AS
(SELECT database_id, object_id, index_id,
SUM(avg_fragmentation_in_percent * page_count) / Sum(page_count)
as POURCENTAGE_DE_FRAGMENTATION
FROM sys.dm_db_index_physical_stats(DB_ID(), NULL, NULL, NULL, ''DETAILED'')
WHERE index_type_desc IN (''CLUSTERED INDEX'', ''NONCLUSTERED INDEX'')
AND alloc_unit_type_desc = ''IN_ROW_DATA''
GROUP BY database_id, object_id, index_id
HAVING SUM(page_count) &gt; 100
AND SUM(avg_fragmentation_in_percent * page_count) &gt; 0)
SELECT DB_NAME(database_id) + ''.'' + s.name + ''.'' + o.name + ''.'' + i.name
as NOM_INDEX, F.POURCENTAGE_DE_FRAGMENTATION
FROM T_FRAG AS F
INNER JOIN sys.objects AS o
ON F.object_id = o.object_id
INNER JOIN sys.schemas AS s
ON o.schema_id = s.schema_id
INNER JOIN sys.indexes AS i
On F.object_id = i.object_id
And F.index_id = i.index_id
      </Value>
      <OutputTable>IndexFragmentation</OutputTable>
   </Query><Databases><UserUserDatabases="true"/></Databases>
</ns:TSQLQueryCollector>'
AS XML);

-- Rcupration de lidentifiant de type de collecteur
-- pour la collecte de donnes Transact-SQL
-- depuis la table des types de collectes
DECLARE @collector_type uniqueidentifier;
SELECT @collector_type = collector_type_uid
FROM   msdb.dbo.syscollector_collector_types
WHERE  name = N'Generic T-SQL Query Collector Type';

SELECT @collector_type AS UID_collector_type;

DECLARE @collectionitem INT;

-- Cration des items collects
EXEC msdb.dbo.sp_syscollector_create_collection_item
              @name = N'Fragmentation des index',
              @parameters = @parameters,
              @collection_item_id = @collectionitem OUTPUT,
              @collection_set_id = @collectionsetid,
              @collector_type_uid = @collector_type;

SELECT @collectionitem AS ID_@collectionitem;
